import java.util.*;
    
/** An instance produces permutations of a String */
public class PermutationGenerator implements Enumerator {
    private String word;  // The word whose permutations are being enumerated
    private boolean hasAnother= true; // there is another permutation to enumerate
    
    // if word is not "", then we use these variables:
    private int pos;        // 0 <= pos <= word.length
    private String subWord; // word but with character word[pos] removed
    private PermutationGenerator subEnum; // An enumeration for subWord
    
    /* Representation invariant, in the case that word != "": 
       (1) All permutations of word that begin with a letter in word[0..pos-1]
           have been generated.
       (2) All permutations of the form
                word[pos] + e 
           where e was enumerated by subEnum have been enumerated
       (3) If pos < word.length, e has another permutation to enumerate
    */
    
    /** Constructor: an enumeration for w */
    public PermutationGenerator(String w) {
        word= w;
        pos= 0;
        if (word.length() != 0) {
            subWord= word.substring(1);
            subEnum= new PermutationGenerator(subWord);
        }
    }
    
    /** = this enumeration has another element */
    public boolean hasMoreElements() {
        return hasAnother;
    }
    
    /** = the next permutation of this enumeration */
    public Object nextElement() {
        if (word.equals("")) {
            hasAnother= false;
            return "";
        }
        
        String next= word.charAt(pos) + (String) subEnum.nextElement();
        getReadyForNext();
        return next;
    }

    /** Word is not "". If subEnum has no more enumerations, then add 1
        to pos, keeping the definition of all fields true */
    private void getReadyForNext() {
        if (subEnum.hasMoreElements()) {
            return;
        }
        pos= pos+1;
        if (pos == word.length()) {
            hasAnother= false;
            return;
        }
        subWord= word.substring(0,pos) + word.substring(pos+1);
        subEnum= new PermutationGenerator(subWord);
    }
}